// Generated by gmmproc 2.51.6 -- DO NOT MODIFY!
#ifndef _GDKMM_RECTANGLE_H
#define _GDKMM_RECTANGLE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: rectangle.hg,v 1.2 2004/01/05 17:32:12 murrayc Exp $ */

/* rectangle.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/value.h>
#include <gdk/gdk.h>


namespace Gdk
{

/** Gdk::Rectangle is a structure holding the position and size of a rectangle.
 * The intersection of two rectangles can be computed with intersect(). To find the union of two rectangles use union().
 */
class Rectangle
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Rectangle;
  using BaseObjectType = GdkRectangle;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Rectangle(const Rectangle& other) noexcept;
  Rectangle& operator=(const Rectangle& other) noexcept;

  Rectangle(Rectangle&& other) noexcept;
  Rectangle& operator=(Rectangle&& other) noexcept;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  Rectangle();

  explicit Rectangle(const GdkRectangle* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  GdkRectangle*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const GdkRectangle* gobj() const { return &gobject_; }

protected:
  GdkRectangle gobject_;

private:
  
public:
//_CUSTOM_DEFAULT_CTOR
//Rectangle();

  /** Creates a new rectangle instance with these dimensions.
   */
  Rectangle(int x, int y, int width, int height);

  /** Calculates the union of two rectangles. 
   * The union of this rectangle and @a src2 is the smallest rectangle which includes both this rectangle and @a src2 within it. 
   *
   * This method returns a reference to this instance, allowing you to then call another method easily. 
   * For instance: rect.join(src2).intersect(src3);
   *
   * @param src2 The rectangle with which to calculate the union with this rectangle.
   * @returns A reference to this rectangle.
   */
  Rectangle& join(const Rectangle& src2);
  
  /** Calculates the intersection of two rectangles, changing this rectangle. 
   * If the rectangles do not intersect, this rectangle's width and height is set to 0 and its x and y values are undefined.
   *
   * This method returns a reference to this instance, allowing you to then call another method easily. 
   * For instance: rect.intersect(src2).join(src3);
   *
   * @param src2 The rectangle with which to calculate the intersection with this rectangle.
   * @returns A reference to this rectangle.
   */
  Rectangle& intersect(const Rectangle& src2);
  
  /** Calculates the intersection of two rectangles, changing this rectangle. 
   * If the rectangles do not intersect, this rectangle's width and height is set to 0 and its x and y values are undefined.
   *
   * This method returns a reference to this instance, allowing you to then call another method easily. 
   * For instance: rect.intersect(src2).join(src3);
   *
   * @param src2 The rectangle with which to calculate the intersection with this rectangle.
   * @param rectangles_interesect This will be set to true if the rectangles intersect.
   * @returns A reference to this rectangle.
   */
  Rectangle& intersect(const Rectangle& src2, bool& rectangles_intersect);

  /** Checks whether either the width or height are 0.
   * @result Whether this rectangle has any non-0 area.
   */
  bool has_zero_area() const;

  int get_x() const;
  void set_x(const int& value);
  int get_y() const;
  void set_y(const int& value);
  int get_width() const;
  void set_width(const int& value);
  int get_height() const;
  void set_height(const int& value);


};

} // namespace Gdk


namespace Glib
{

/** @relates Gdk::Rectangle
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Gdk::Rectangle& wrap(GdkRectangle* object);

/** @relates Gdk::Rectangle
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Gdk::Rectangle& wrap(const GdkRectangle* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::Rectangle> : public Glib::Value_Boxed<Gdk::Rectangle>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GDKMM_RECTANGLE_H */

